#!/usr/bin/perl
# 
# $Header: has/demo/crs/coldfailover/osds/act_db.pl /unix/5 2009/06/16 02:19:08 rknapp Exp $
#
# act_db.pl
# 
# Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      act_db.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      This perl script is the action script for start / stop / check
#      the Oracle Instance in a cold failover configuration.
#
#      Place this file in <CRS_HOME>/crs/public/
#
#    NOTES
#      Edit the perl installation directory as appropriate.
#
#    MODIFIED   (MM/DD/YY)
#    rknapp      05/19/09 - add clean part                         
#    rknapp      05/14/09 - made script more Solaris friendly      
#    rknapp      05/30/07 - XbranchMerge rknapp_coldfailover from main
#    rknapp      06/24/07 - fixed bug with multiple SID 
#    rvenkate    04/05/07 - checkin into demo dir
#    pnewlan     01/17/07 - Use Environment variables rather than hard code 
#                         - HOME & SID
#    pnewlan     11/23/06 - oracle OS user invoker
#    rknapp      05/22/06 - Creation
# 

$ORACLE_HOME = "$ENV{_USR_ORA_LANG}";
$ORACLE_SID = "$ENV{_USR_ORA_SRV}";
$USES_ASM = "$ENV{_USR_ORA_FLAGS}";
if ($#ARGV != 0 ) {
        print "usage: start stop check required \n";
exit;
}
$command = $ARGV[0];
# Database start stop check
# Start database
if ($command eq "start" ) {
        if ($USES_ASM eq "1") {
            #make sure ASM is running now
            system ("
                ORACLE_HOME=$ORACLE_HOME
                export ORACLE_HOME
                $ORACLE_HOME/bin/srvctl start asm -n `hostname -s`
                    ");
        }
        system ("
        ORACLE_SID=$ORACLE_SID
        export ORACLE_SID
        ORACLE_HOME=$ORACLE_HOME
        export ORACLE_HOME
        LD_LIBRARY_PATH=$ORACLE_HOME/lib:$LD_LIBRARY_PATH
        export LD_LIBRARY_PATH
#       export TNS_ADMIN=$ORACLE_HOME/network/admin  # optionally set TNS_ADMIN here
        $ORACLE_HOME/bin/sqlplus /nolog <<EOF
        connect / as sysdba
        startup force
        quit
        EOF" );
        $MYRET = check();
        exit $MYRET;
        }
# Stop database
if ($command eq "stop" ) {
        system ("
        ORACLE_SID=$ORACLE_SID
        export ORACLE_SID
        ORACLE_HOME=$ORACLE_HOME
        export ORACLE_HOME
        LD_LIBRARY_PATH=$ORACLE_HOME/lib:$LD_LIBRARY_PATH
        export LD_LIBRARY_PATH
#       export TNS_ADMIN=$ORACLE_HOME/network/admin  # optionally set TNS_ADMIN here
        $ORACLE_HOME/bin/sqlplus /nolog <<EOF
        connect / as sysdba
        shutdown immediate
        quit
        EOF" );
        $MYRET = check();
        if ($MYRET eq 1) {
            exit 0;
            }
        else {
            exit 1;
        }  
        }
# Check database
if ($command eq "check" ) {
        $MYRET = check();
        exit $MYRET;
}
sub check {
        my($check_proc,$process) = @_;
       $process = "ora_pmon_$ORACLE_SID";
       $check_proc = qx(ps -ae -o args | grep -w ora_pmon_$ORACLE_SID | grep -v grep);
        chomp($check_proc);
        if ($process eq $check_proc) {
                $RET=0;
        } else {
                $RET=1;
        }
        return $RET;
}
# Clean database
if ($command eq "clean") {
        my $kill_proc = qx(ps -aef | grep -w ora_pmon_$ORACLE_SID | grep -v grep | awk '{print \$2}'| xargs kill -9 $1);
        exit 0;
}

